#ifndef USERPROCESS_H
#define USERPROCESS_H

#include "sn_process.h"
#include "message.h"

#define NULL_MESSAGE  -1

class User_Process : public SN_Process
{
public:
	enum Status {unknown, leader, non_leader};

private:
	int num_processes;

	int u;
	Message send_plus;
	Message send_minus;
	Status status;
	unsigned int phase;

	// For converting between SN_Messages and Messages
	SN_Message* _Convert_Message(Message *msg);
	map<SN_Message *,int> _Convert_Messages(map<Message *,int> msgs);
	map<Message *,int> _Convert_SN_Messages(map<SN_Message *,int> sn_msgs);

public:
	User_Process(int);

	void Set_Start_State();
	void Transition(map <SN_Message*,int> incoming_msgs);
	void Generate_Messages();
};

#endif // USERPROCESS_H